function [t,q,dq,ddq]=motion_definition_SIMSYS_TD1(dt)
%% Sample motion : circular motion

t=0:dt:2;
addt=0:dt:0.2;

qa=zeros(2,numel(t));
qb=zeros(2,numel(addt));
qa(1,:)=pi/18*t-pi/18*sin(0.5*2*pi*t)/(0.5*2*pi);
qa(2,:)=pi/3*t-pi/3*sin(0.5*2*pi*t)/(0.5*2*pi);
qb(1,1:numel(addt))=pi/9-pi/1.8*addt+pi/1.8*sin(5*2*pi*addt)/(5*2*pi);
qb(2,1:numel(addt))=pi/1.5-pi/0.35*addt+pi/0.35*sin(5*2*pi*addt)/(5*2*pi);
q=[qa qb];
addt=addt+t(numel(t));
t=[t addt];
dq=derivate_2order(dt,q')';
ddq=derivate_2order(dt,dq')';

end